//+------------------------------------------------------------------+
//|                                         #MTF Supertrend line.mq4 |
//|                                      Copyright  2006, Eli hayun |
//|                                          http://www.elihayun.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Eli hayun"
#property link      "http://www.elihayun.com"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Bisque
#property indicator_color2 LightSkyBlue
#property indicator_color3 PeachPuff
#property indicator_color4 PaleTurquoise
#property indicator_color5 MistyRose
#property indicator_color6 Aqua
#property indicator_color7 Magenta
#property indicator_color8 Lavender
//---- buffers
double buf_up1D[];
double buf_down1D[];

double buf_up4H[];
double buf_down4H[];

double buf_up1H[];
double buf_down1H[];

double buf_up30M[];
double buf_down30M[];

extern int Period_1 = PERIOD_M5;
extern int Period_2 = PERIOD_M15;
extern int Period_3 = PERIOD_M30;
extern int Period_4 = PERIOD_H1;
extern int     TimeFrame   = 0;

extern bool AutoDisplay      = true;

extern bool display_Period_1 = true;
extern bool display_Period_2 = true;
extern bool display_Period_3 = true;
extern bool display_Period_4 = true;

extern bool Play_Sound = true;
extern bool additional = false;
double alertTag;
bool TurnedUp = false;
bool TurnedDown = false;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators

   if (AutoDisplay)
   {
      display_Period_1 = false; display_Period_2 = false; display_Period_3 = false; display_Period_4 = false;
      switch (Period())
      {
         case PERIOD_M1  :  SetValues(PERIOD_M1,  PERIOD_M5, PERIOD_M15,PERIOD_M30, true,  true,  false, false); break;
         case PERIOD_M5  :  SetValues(PERIOD_M5,  PERIOD_M15,PERIOD_M30,PERIOD_H1,  true,  true,  false, false); break;
         case PERIOD_M15 :  SetValues(PERIOD_M5,  PERIOD_M15,PERIOD_M30,PERIOD_H1,  true,  true,  true,  false); break;
         case PERIOD_M30 :  SetValues(PERIOD_M5,  PERIOD_M15,PERIOD_M30,PERIOD_H1,  false, true,  true,  false); break;
         case PERIOD_H1  :  SetValues(PERIOD_M15, PERIOD_M30,PERIOD_H1, PERIOD_H4,  false, false, true,  true);  break;
         case PERIOD_H4  :  SetValues(PERIOD_M30, PERIOD_H1, PERIOD_H4, PERIOD_D1,  false, true,  true,  true);  break;
         case PERIOD_D1  :  SetValues(PERIOD_H1,  PERIOD_H4, PERIOD_D1, PERIOD_W1,  true,  true,  true,  false); break;
         case PERIOD_W1  :  SetValues(PERIOD_H4,  PERIOD_D1, PERIOD_W1, PERIOD_MN1, false, true,  true,  false); break;
         case PERIOD_MN1 :  SetValues(PERIOD_H4,  PERIOD_D1, PERIOD_W1, PERIOD_MN1, false, false, true,  true);  break;
      }
   }
   
   
   int draw = DRAW_LINE; if (!display_Period_4) draw = DRAW_NONE;
   
   SetIndexStyle(0,draw, STYLE_SOLID, 4);
   SetIndexBuffer(0,buf_up1D);
   SetIndexStyle(1,draw, STYLE_SOLID, 4);
   SetIndexBuffer(1,buf_down1D);
   SetIndexLabel(0, tf2txt(Period_4)); SetIndexLabel(1, tf2txt(Period_4));
   
   draw = DRAW_LINE; if (!display_Period_3) draw = DRAW_NONE;
   SetIndexStyle(2,draw, STYLE_SOLID, 4);
   SetIndexBuffer(2,buf_up4H);
   SetIndexStyle(3,draw, STYLE_SOLID, 4);
   SetIndexBuffer(3,buf_down4H);
   SetIndexLabel(2, tf2txt(Period_3)); SetIndexLabel(3, tf2txt(Period_3));


   draw = DRAW_LINE; if (!display_Period_2) draw = DRAW_NONE;
   SetIndexStyle(4,draw, STYLE_SOLID, 4);
   SetIndexBuffer(4,buf_up1H);
   SetIndexStyle(5,draw, STYLE_SOLID, 4);
   SetIndexBuffer(5,buf_down1H);
   SetIndexLabel(4, tf2txt(Period_2)); SetIndexLabel(5, tf2txt(Period_2));

   draw = DRAW_LINE; if (!display_Period_1) draw = DRAW_NONE;
   SetIndexStyle(6,draw, STYLE_SOLID, 4);
   SetIndexBuffer(6,buf_up30M);
   SetIndexStyle(7,draw, STYLE_SOLID, 4);
   SetIndexBuffer(7,buf_down30M);
   SetIndexLabel(6, tf2txt(Period_1)); SetIndexLabel(7, tf2txt(Period_1));
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
   int i=0, y1d=0, y4h=0, y1h=0, y30m=0;
   int limit=Bars-counted_bars+TimeFrame/Period();

   datetime TimeArray_1D[] ,TimeArray_4H[], TimeArray_1H[], TimeArray_30M[];
//----
   ArrayCopySeries(TimeArray_1D,MODE_TIME,Symbol(),Period_4); 
   ArrayCopySeries(TimeArray_4H,MODE_TIME,Symbol(),Period_3); 
   ArrayCopySeries(TimeArray_1H,MODE_TIME,Symbol(),Period_2); 
   ArrayCopySeries(TimeArray_30M,MODE_TIME,Symbol(),Period_1);
      
   for(i=0, y1d=0,  y4h=0,  y1h=0,  y30m=0;i<limit;i++)
   {
      if (Time[i]<TimeArray_1D[y1d]) y1d++;
      if (Time[i]<TimeArray_4H[y4h]) y4h++;
      if (Time[i]<TimeArray_1H[y1h]) y1h++;
      if (Time[i]<TimeArray_30M[y30m]) y30m++;
 
       buf_up1D[i] = iCustom(NULL, Period_4, "SuperTrend", false, 1, y1d);
      buf_down1D[i] = iCustom(NULL, Period_4, "SuperTrend", false, 0, y1d);

      if (i < 2)
      {
         SoundAlarm(buf_up1D[i] , iCustom(NULL, Period_4, "SuperTrend", false, 1, y1d+1), 4, "Down");
         SoundAlarm(buf_down1D[i] , iCustom(NULL, Period_4, "SuperTrend", false, 0, y1d+1), 4, "Up");
     }
      buf_up4H[i] = iCustom(NULL, Period_3, "SuperTrend", false, 1, y4h);
      buf_down4H[i] = iCustom(NULL, Period_3, "SuperTrend", false, 0, y4h);

      if (i < 2)
      {
         SoundAlarm(buf_up4H[i] , iCustom(NULL, Period_3, "SuperTrend", false, 1, y4h+1), 3, "Down");
         SoundAlarm(buf_down4H[i] , iCustom(NULL, Period_3, "SuperTrend", false, 0, y4h+1), 3, "Up");
      }
      
      buf_up1H[i] = iCustom(NULL, Period_2, "SuperTrend", false, 1, y1h);
      buf_down1H[i] = iCustom(NULL, Period_2, "SuperTrend", false, 0, y1h);
      
      if (i < 2)
      {
         SoundAlarm(buf_up1H[i] , iCustom(NULL, Period_2, "SuperTrend", false, 1, y1h+1), 2, "Down");
         SoundAlarm(buf_down1H[i] , iCustom(NULL, Period_2, "SuperTrend", false, 0, y1h+1), 2, "Up");
      }
      
      buf_up30M[i] = iCustom(NULL, Period_1, "SuperTrend", false, 1, y30m);
      buf_down30M[i] = iCustom(NULL, Period_1, "SuperTrend", false, 0, y30m);

      if (i < 2)
      {
         SoundAlarm(buf_up30M[i] , iCustom(NULL, Period_1, "SuperTrend", false, 1, y30m+1), 1, "Down");
         SoundAlarm(buf_down30M[i] , iCustom(NULL, Period_1, "SuperTrend", false, 0, y30m+1), 1, "Up");
      }
// 1up was <= and worked on down but gave multiple signals 
  if(i == 0 && buf_up30M[i] == buf_up1H[i] && buf_up30M[i] != EMPTY_VALUE && buf_up1H[i] != EMPTY_VALUE && buf_down30M[i] == EMPTY_VALUE && buf_down1H[i] != EMPTY_VALUE && alertTag!=Time[0]){
   Alert("1up, Supertrend3 going Down on ",Symbol()," ",Period()," bu30= ",buf_up30M[i]," bu1H= ",buf_up1H[i]," bd30 ",buf_down30M[i]," bd1H= ",buf_down1H[i]," imit= ",limit," i= ",i);
     alertTag = Time[0];
    }
  if(limit ==2 && i==0 && buf_up30M[i] > buf_up1H[i] && buf_up1H[i] == buf_down1H[i] && buf_up30M[i] != EMPTY_VALUE && buf_up1H[i] != EMPTY_VALUE && buf_down30M[i] == EMPTY_VALUE && buf_down1H[i] != EMPTY_VALUE && alertTag!=Time[0]){
   Alert("1aup, Supertrend3 going Down on ",Symbol()," ",Period()," bu30= ",buf_up30M[i]," bu1H= ",buf_up1H[i]," bd30 ",buf_down30M[i]," bd1H= ",buf_down1H[i]," imit= ",limit," i= ",i);
     alertTag = Time[0];
     }
  if(limit ==2 && i==0 && buf_up30M[i] > buf_up1H[i] && buf_up30M[i] != EMPTY_VALUE && buf_up1H[i] != EMPTY_VALUE && buf_down30M[i] != EMPTY_VALUE && buf_down1H[i] == EMPTY_VALUE && alertTag!=Time[0]){
   Alert("1bup, Supertrend3 going Down on ",Symbol()," ",Period()," bu30= ",buf_up30M[i]," bu1H= ",buf_up1H[i]," bd30 ",buf_down30M[i]," bd1H= ",buf_down1H[i]," imit= ",limit," i= ",i);
     alertTag = Time[0];
    }       
    if(limit ==2 && i==0 && buf_up30M[i] < buf_up1H[i] && buf_down30M[i] == EMPTY_VALUE && buf_up30M[i] != EMPTY_VALUE &&  buf_up1H[i] != EMPTY_VALUE &&  buf_down1H[i] != EMPTY_VALUE && alertTag!=Time[0]){
   Alert("2up, Supertrend3 going Up on ",Symbol()," ",Period()," bu30= ",buf_up30M[i]," bd1H= ",buf_down1H[i]," bd30 ",buf_down30M[i]," bu1H= ",buf_up1H[i]," imit= ",limit," i= ",i);
   alertTag = Time[0];
    }
    if(limit ==2 && i==0 && buf_down30M[i] == buf_up1H[i] && buf_down30M[i] != EMPTY_VALUE && buf_up1H[i] != EMPTY_VALUE && alertTag!=Time[0]){
   Alert("3up, Supertrend3 going Up on ",Symbol()," ",Period()," bd30= ",buf_down30M[i]," bu1H= ",buf_up1H[i]," bu30= ",buf_up30M[i]," bd30 "," bd1H= ",buf_down1H[i]," imit= ",limit," i= ",i);
   alertTag = Time[0];
    }
    if(limit==2 && i==1 && buf_down30M[i] < buf_down1H[i] && buf_down30M[i] != EMPTY_VALUE && buf_down1H[i] != EMPTY_VALUE && buf_up30M[i] == EMPTY_VALUE && buf_up1H[i] != EMPTY_VALUE && alertTag!=Time[0]){
   Alert("4up, Supertrend3 going Up on ",Symbol()," ",Period()," bd30= ",buf_down30M[i]," bd1H= ",buf_down1H[i]," bu30= ",buf_up30M[i]," bu1H= ",buf_up1H[i]," imit= ",limit," i= ",i);
   alertTag = Time[0];
    }
  if(i == 0 && buf_down1H[i] == buf_up1H[i] && buf_down1H[i] != EMPTY_VALUE && buf_up1H[i] != EMPTY_VALUE && buf_up30M[i] != EMPTY_VALUE && buf_down30M[i] != EMPTY_VALUE && alertTag!=Time[0]){
   Alert("5up, Supertrend3 going Down on ",Symbol()," ",Period()," bu30= ",buf_up30M[i]," bu1H= ",buf_up1H[i]," bd30 ",buf_down30M[i]," bd1H= ",buf_down1H[i]," imit= ",limit," i= ",i);
     alertTag = Time[0];
    }
  if(i == 0 && buf_down30M[i] == buf_up30M[i] && buf_down30M[i] != EMPTY_VALUE && buf_up30M[i] != EMPTY_VALUE && buf_down1H[i] != EMPTY_VALUE && buf_up1H[i] != EMPTY_VALUE && alertTag!=Time[0]){
   Alert("6up, Supertrend3 going Down on ",Symbol()," ",Period()," bu30= ",buf_up30M[i]," bu1H= ",buf_up1H[i]," bd30 ",buf_down30M[i]," bd1H= ",buf_down1H[i]," imit= ",limit," i= ",i);
     alertTag = Time[0];
    }
//up trend 1H and 4H
   if(additional == true && buf_up1H[i] >= buf_up4H[i] && buf_up1H[i] != EMPTY_VALUE && buf_up4H[i] != EMPTY_VALUE && alertTag!=Time[0]){
    Alert("2up, Supertrend3 going Up on ",Symbol()," ",Period()," bu1h= ",buf_up1H[i]," bu4H= ",buf_up4H[i]," i= ",i," y30= ",y30m," y1h= ",y1h," imit= ",limit);
    alertTag = Time[0];
     }
   if(additional == true && buf_up1H[i] >= buf_down4H[i]&& buf_up1H[i] != EMPTY_VALUE && buf_down4H[i] != EMPTY_VALUE && alertTag!=Time[0]){
    Alert("2up, Supertrend3 going Up on ",Symbol()," ",Period()," bu1h= ",buf_up1H[i]," bd1h= ",buf_down1H[i]," i= ",i," y30= ",y30m," y1h= ",y1h," imit= ",limit);
    alertTag = Time[0];
     }
// down trend 1H and 4H
   if(additional == true && buf_down1H[i] == buf_down4H[i] && buf_down1H[i] != EMPTY_VALUE && buf_down4H[i] != EMPTY_VALUE && !alertTag!=Time[0]){
    Alert("2d, Supertrend3 going Down on ",Symbol()," ",Period()," bu1h= ",buf_up1H[i]," bd1h= ",buf_down1H[i]," bu4H= ",buf_up4H[i]," bd4H= ",buf_down4H[i]," i= ",i," y30= ",y30m," y1h= ",y1h," imit= ",limit);
            TurnedDown = true;
            TurnedUp = false;
     }
   if(additional == true && buf_down1H[i] == buf_up4H[i] && buf_down1H[i] != EMPTY_VALUE && buf_up4H[i] != EMPTY_VALUE && alertTag!=Time[0]){
    Alert("2d, Supertrend3 going Down on ",Symbol()," ",Period()," bu1h= ",buf_up1H[i]," bd1h= ",buf_down1H[i]," bu4H= ",buf_up4H[i]," bd4H= ",buf_down4H[i]," i= ",i," y30= ",y30m," y1h= ",y1h," imit= ",limit);
    alertTag = Time[0];
     }

 //up trend 4H and 1D
   if(additional == true && buf_up4H[i] == buf_up1D[i] && buf_up4H[i] != EMPTY_VALUE && buf_up1D[i] != EMPTY_VALUE && alertTag!=Time[0]){
    Alert("3up, Supertrend3 going Up on ",Symbol()," ",Period()," bu4h= ",buf_up4H[i]," bd1d= ",buf_down1D[i]," i= ",i," y30= ",y30m," y1h= ",y1h," imit= ",limit);
    alertTag = Time[0];
     }
   if(additional == true && buf_up4H[i] == buf_down1D[i] && buf_up4H[i] != EMPTY_VALUE && buf_down1D[i] != EMPTY_VALUE && alertTag!=Time[0]){
    Alert("3up, Supertrend3 going Up on ",Symbol()," ",Period()," bu4h= ",buf_up4H[i]," bd1d= ",buf_down1D[i]," i= ",i," y30= ",y30m," y1h= ",y1h," imit= ",limit);
    alertTag = Time[0];
     }
     
// down trend 4H and 1D
   if(additional == true && buf_down4H[i] == buf_down1D[i] && buf_down4H[i] != EMPTY_VALUE && buf_down1D[i] != EMPTY_VALUE && alertTag!=Time[0]){
    Alert("3d, Supertrend3 going Down on ",Symbol()," ",Period()," bd4h= ",buf_down4H[i]," bd1d= ",buf_down1D[i]," i= ",i," y30= ",y30m," y1h= ",y1h," imit= ",limit);
    alertTag = Time[0];
     }
   if(additional == true && buf_down4H[i] == buf_up1D[i]&& buf_down4H[i] != EMPTY_VALUE && buf_up1D[i] != EMPTY_VALUE && alertTag!=Time[0]){
    Alert("3d, Supertrend3 going Down on ",Symbol()," ",Period()," bu4h= ",buf_up4H[i]," bd4h= ",buf_down4H[i]," bu1d= ",buf_up1D[i]," i= ",i," y30= ",y30m," y1h= ",y1h," imit= ",limit);
    alertTag = Time[0];
     }
   }
   return(0);
  }
//+------------------------------------------------------------------+

void SoundAlarm(double v1, double v2, int prd, string sDir)
{
   bool bDisplay = true;
   string sPrd = "";
   
   static bool bAlreadyAlarm = true;
   
   if (NewBar())
      bAlreadyAlarm = false;
   
   switch ( prd )
   {
      case 4  : bDisplay = display_Period_4;  sPrd = tf2txt(Period_3); break;
      case 3  : bDisplay = display_Period_3;  sPrd = tf2txt(Period_3); break;
      case 2  : bDisplay = display_Period_2;  sPrd = tf2txt(Period_2); break;
      case 1  : bDisplay = display_Period_1;  sPrd = tf2txt(Period_1); break;
   }
   
   if ((!Play_Sound) || (!bDisplay) || bAlreadyAlarm)
      return;
//    if ((v1 != EMPTY_VALUE) && (v2 == EMPTY_VALUE))   
 //  {
 //     Alert("SuperTrend colour change alert changed direction to " ,sDir, " at ", sPrd," on ",Symbol()); 
 //     bAlreadyAlarm = true;
 //  }  
 }

bool NewBar()
{
   static datetime dt = 0;
   
   if (Time[0] != dt)
   {
      dt = Time[0];
      return(true);
   }
   return(false);
}


string tf2txt(int tf)
{
   if (tf == PERIOD_M1)    return("M1");
   if (tf == PERIOD_M5)    return("M5");
   if (tf == PERIOD_M15)    return("M15");
   if (tf == PERIOD_M30)    return("M30");
   if (tf == PERIOD_H1)    return("H1");
   if (tf == PERIOD_H4)    return("H4");
   if (tf == PERIOD_D1)    return("D1");
   if (tf == PERIOD_W1)    return("W1");
   if (tf == PERIOD_MN1)    return("MN1");
   
   return("??");
}

void SetValues(int p1, int p2, int p3, int p4, bool d1, bool d2, bool d3, bool d4)
{
   display_Period_1 = d1; display_Period_2 = d2; display_Period_3 = d3; display_Period_4 = d4;
   Period_1 = p1;   Period_2 = p2; Period_3 = p3; Period_4 = p4; 
}

